﻿//キーがあればキーを打ち、無ければ静的値を入れる。
(function (){
    //ビューワーを選択しておく。
    app.activeViewer.setActive();
    var mAi = app.project.activeItem;
    //------------------------------------------------------------------------------------
    //取得したカスタム値テキストorオブジェクトを型変換する。
    if( props.length === 0){return;}
    var mPropValType = props[0].propertyValueType;
    var mVal = mGetVal( mPropValType, valueTxt, valueObj );
    
    //------------------------------------------------------------------------------------
    for (var i = 0; i < props.length; i++) {
        var mProp = props[i];
        //プロパティのキーフレームがゼロの場合、キーを打たずに値を入れる。
        if (mProp.numKeys === 0) { mProp.setValue(mVal);} 
         //すでにキーが打たれていれば打つ。
        else { mProp.setValueAtTime(mAi.time, mVal);}
    }
    //最後にビューワーを選択しておく。
    app.activeViewer.setActive();
    
    //------------------------------------------------------------------------------------
    //------------------------------------------------------------------------------------
    function mGetVal( aPropValType, aValTxt, aValObj ){
        var mVal = null;
        if( aPropValType === PropertyValueType.NO_VALUE
        || aPropValType === PropertyValueType.CUSTOM_VALUE){    
            //ノーバリューかカスタムバリューならヌルをリターンする。
            return null;
        }else if ( aPropValType === PropertyValueType.SHAPE
        || aPropValType === PropertyValueType.MARKER){
            //オブジェクト。 
            mVal = aValObj;
        }else if (  aPropValType === PropertyValueType.TEXT_DOCUMENT){
            //テキスト（オブジェクト）。
            mVal = aValTxt;
        }else if ( aPropValType === PropertyValueType.ThreeD_SPATIAL
        || aPropValType === PropertyValueType.ThreeD
        || aPropValType === PropertyValueType.TwoD_SPATIAL
        || aPropValType === PropertyValueType.TwoD
        || aPropValType ===  PropertyValueType.COLOR){
            //配列。   
            mVal = aValTxt;
            if ( /,/.test(mVal)) {
                var mStrAry = mVal.split(",");
                var mAry = [];
                for (var i = 0; i < mStrAry.length; i++) {
                    mAry.push( parseFloat(mStrAry[i]) );
                }
                mVal = mAry;
            }
        }else if ( aPropValType === PropertyValueType.OneD
        || aPropValType === PropertyValueType.LAYER_INDEX
        || aPropValType === PropertyValueType.MASK_INDEX){
            //単一数値。   
            mVal = parseFloat(aValTxt);
            if(isNaN( mVal )){ return null;}
        }
        return mVal;
    }
})();